<?php $__env->startSection('header-php'); ?>
  <?php
  $body_id = '';
  $body_class = '';
  ?>
<?php $__env->stopSection(); ?> 

<?php $__env->startSection('meta-dynamic'); ?>
  <title><?php echo e(config('app.name')); ?></title>  
  <meta name="description" content="-">    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('main'); ?>
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1>
      States
    </h1>
    
    <!-- 
    <ol class="breadcrumb">
      <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
      <li class="active">Here</li>
    </ol> 
    -->

  </section>

  <!-- Main content -->
    <section class="content container-fluid">

        <!--------------------------
          | Your Page Content Here |
          -------------------------->

        <?php if(Session::has('message')): ?>
            <div class="alert <?php echo e(Session::get('alert_class')); ?>">
              <button type="button" class="close" data-dismiss="alert">&times</button>
              <?php echo e(Session::get('message')); ?>

            </div>
        <?php endif; ?>    
        
        <div class="row">
            <div class="col-md-12">
              <div class="box">
                <div class="box-header with-border">
                    <h3 class="box-title">State List</h3>
                    <div class="pull-right">
                        <a href="<?php echo e(route('state/create')); ?>" class="btn btn-primary">
                            <i class="fa fa-plus"></i> Create New
                        </a>
                    </div>
                </div>
                <!-- /.box-header -->

                <div class="box-body">

                  <div class="row">
                    <?php echo e(Form::open(array('url' => 'state', 'class' => '', 'method' => 'get'))); ?>


                      <div class="col-xs-12">
                        <div class="row">
                          <div class="col-md-6">
                            <div class="form-group">
                              <label>Search By: </label><br />
                              <select name="search_by" class="form-control select2" style="width: 30%; float: left;">
                                <option value="name" selected="selected">Name</option>
                              </select>
                              <input class="form-control" type="text" value="<?php echo $search_field; ?>" name="search_field" placeholder="Default Search" style="width: 70%; float: right;">
                            </div>
                            <!-- /.form-group -->
                          </div>
                          <!-- /.col -->

                          <div class="col-md-6">
                            <div class="form-group">
                              <label>&nbsp;</label><br />
                              <button type="submit" class="btn btn-primary">Filter</button>
                              <a class="btn btn-success" href="<?php echo e(route('state')); ?>">Refresh</a>
                            </div>
                            <!-- /.form-group -->
                          </div>
                        </div>                

                      </div>                      
                    <?php echo Form::close(); ?>         
                  </div>

                  <table class="table table-bordered table-hover">
                    <tr>
                      <th style="width: 1%;" >#</th>
                      <th>Name</th>
                      <th style="width:10%;">Action</th>
                    </tr>
                    <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $st): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($st->id); ?></td>
                            <td><?php echo e($st->name); ?></td>
                            <td>
                                <a href="javascript:void(0);" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#modalDelete-<?= $st->id; ?>">
                                    <i class="fa fa-trash"></i> Delete
                                </a>
                                <a href="<?php echo e(route('state/edit',[Hashids::encode($st->id)])); ?>" class="btn btn-xs btn-primary">
                                    <i class="fa fa-edit"></i> Edit
                                </a>                                                              
                            </td>
                        </tr>

                        <div id="modalDelete-<?= $st->id; ?>" class="modal fade bs-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true" style="text-align: left">
                            <div class="modal-dialog modal-md">
                              <div class="modal-content">

                                <div class="modal-header">
                                  <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span>
                                  </button>
                                  <h4 class="modal-title" id="myModalLabel">Delete</h4>
                                </div>
                                <div class="modal-body">
                                  Are you sure you want to delete selected state?
                                </div>
                                <div class="modal-footer">
                                  <?php echo e(Form::open(array('url' => 'state/destroy'))); ?>

                                    <?php echo Form::hidden('id', Hashids::encode($st->id) ,[]); ?>
                                    <button type="button" class="btn btn-default" data-dismiss="modal">No</button>
                                    <button type="submit" class="btn btn-danger">Yes</button>
                                  <?php echo Form::close(); ?>

                                </div>

                              </div>
                            </div>
                        </div>   

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </table>

                </div>
                <!-- /.box-body -->

                <div style="text-align: center;" class="box-footer clearfix">
                    <?php echo e($states->links()); ?>

                </div>

              </div>
              <!-- /.box -->
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->

    </section>
  <!-- /.content -->
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/efvyhdmy/public_html/bizboxxcrm-app/resources/views/state/index.blade.php ENDPATH**/ ?>