<div class="row">
  <div class="col-xs-12 calendar-events-header">
    <div class="pull-left calendar-events-title">Tasks</div>
    <div class="pull-right">
        <a href="javascript:void(0);" class="btn btn-primary" id="" data-toggle="modal" data-target="#modalAddTask">
            <i class="fa fa-plus"></i> Add Task
        </a>          
        <a href="javascript:location.reload();" class="btn btn-primary">
            <i class="fa fa-refresh"></i>
        </a>
    </div>
  </div>
</div>

<div class="row">
  <?php if( $group_id == 3 ){ ?>
    <?php echo e(Form::open(array('url' => 'dashboard', 'class' => '', 'method' => 'get'))); ?>

  <?php }else{ ?>
    <?php echo e(Form::open(array('url' => 'contact_dashboard/'.$contact_id, 'class' => '', 'method' => 'get'))); ?>

  <?php } ?>  

    <div class="col-xs-12">
      <div class="row">
        <div class="col-md-6">
          <div class="form-group">
            <label>Search By: </label><br />
            <select name="search_by" class="form-control select2" style="width: 30%; float: left;">
              <option value="title" selected="selected">Task</option>
            </select>
            <input class="form-control" type="text" value="<?php echo $search_task_field; ?>" name="search_task_field" placeholder="Default Search" style="width: 70%; float: right;">
          </div>
          <!-- /.form-group -->
        </div>
        <!-- /.col -->

        <div class="col-md-6">
          <div class="form-group">
            <label>&nbsp;</label><br />
            <button type="submit" class="btn btn-primary">Filter</button>
            <?php if( $group_id == 3 ){ ?>
              <a class="btn btn-success" href="<?php echo e(url('dashboard/')); ?>">Refresh</a>
            <?php }else{ ?>
              <a class="btn btn-success" href="<?php echo e(url('contact_dashboard/'.$contact_id)); ?>">Refresh</a>
            <?php } ?>
            
          </div>
          <!-- /.form-group -->
        </div>
      </div>                

    </div>                      
  <?php echo Form::close(); ?>         
</div>

<table class="table table-bordered table-hover">
  <tr>
    <th style="width: 1%;" >#</th>
    <th>Task</th>
    <th>Status</th>
    <th>Assigned To</th>
    <th>Created By</th>
    <th>Due Date</th>
    <th>Days</th>
    <th style="width:10%;">Action</th>
  </tr>
  <?php $__currentLoopData = $contact_tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php 
      $assigned_user = "";
      if(!empty($task->assigned_user) || $task->assigned_user != 0) {
        $assigned_user_id = unserialize($task->assigned_user);
        $assigned_user = App\User::find($assigned_user_id);
      }
    ?>
    <tr>
      <td><?php echo e($task->id); ?></td>
      <td><?php echo e($task->title); ?></td>
      <td><?php echo e($task->status); ?></td>
      <?php if($assigned_user): ?>
         <td><?php echo $assigned_user->firstname . " " . $assigned_user->lastname; ?></td>
      <?php else: ?>
         <td>-</td>
      <?php endif; ?>
     
      <?php if(isset($task->user->firstname)): ?>
        <td><?php echo e($task->user->firstname); ?> <?php echo e($task->user->lastname); ?></td>
      <?php else: ?>
        <td>-</td>
      <?php endif; ?>
      <td><?php echo e($task->due_date); ?></td>
      <td><?php echo GlobalHelper::computeDaysBetweenDates(date('Y-m-d'), $task->due_date); ?></td>
      <td>
        <a href="javascript:void(0);" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#modalDeleteTask-<?= $task->id; ?>">
            <i class="fa fa-trash"></i>
        </a>
        <a href="javascript:void(0);" class="btn btn-xs btn-primary" id="" data-toggle="modal" data-target="#modalEditTask-<?= $task->id; ?>">
            <i class="fa fa-edit"></i>
        </a> 
        <a href="javascript:void(0);" class="btn btn-xs btn-primary" id="" data-toggle="modal" data-target="#modalViewTask-<?= $task->id; ?>">
            <i class="fa fa-window-maximize"></i>
        </a>                                                     
      </td>
    </tr>  

    <div id="modalDeleteTask-<?= $task->id; ?>" class="modal fade bs-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true" style="text-align: left">
        <div class="modal-dialog modal-md">
          <div class="modal-content">

            <div class="modal-header">
              <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span>
              </button>
              <h4 class="modal-title" id="myModalLabel">Delete</h4>
            </div>
            <div class="modal-body">
              Are you sure you want to delete selected task?
            </div>
            <div class="modal-footer">
              <?php echo e(Form::open(array('url' => 'contact_task/destroy'))); ?>

                <?php echo Form::hidden('id', Hashids::encode($task->id) ,[]); ?>
                <button type="button" class="btn btn-default" data-dismiss="modal">No</button>
                <button type="submit" class="btn btn-danger">Yes</button>
              <?php echo Form::close(); ?>

            </div>

          </div>
        </div>
    </div>  

    <div id="modalEditTask-<?= $task->id; ?>" class="modal fade bs-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true" style="text-align: left">
        <?php echo e(Form::open(array('url' => 'contact_task/update', 'class' => '', 'id' => 'edit-task-form'))); ?>

          <input type="hidden" name="id" value="<?= Hashids::encode($task->id); ?>">
          <div class="modal-dialog modal-lg">
            <div class="modal-content">

              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span>
                </button>
                <h4 class="modal-title" id="myModalLabel">Update Task</h4>
              </div>
              <div class="modal-body">

                <div class="form-group">
                  <label for="inputLocation">Contact: </label>
                  <?php echo e($contact->firstname); ?> <?php echo e($contact->lastname); ?>

                </div>   

                <div class="form-group">
                  <label for="inputTitle">Title</label>
                  <input type="text" class="form-control" id="title" name="title" value="<?php echo e($task->title); ?>" placeholder="Enter Title" required="">
                </div>         

                <div class="form-group">
                  <label for="inputDescription">Notes</label>
                  <textarea rows="4" cols="50" class="form-control" id="task_notes-<?php echo e($task->id); ?>"  name="notes" required=""><?php echo e($task->notes); ?></textarea>
                </div>            

                <div class="row">
                  <div class="col-xs-4">
                    <div class="form-group">
                      <label for="inputDate">Due Date</label>
                      <input type="text" class="form-control due_date" id="due_date" name="due_date" value="<?php echo e($task->due_date); ?>" placeholder="" required="">
                    </div>                
                  </div>
                  <div class="col-xs-4">
                    <div class="form-group">
                      <label for="inputAssignedUser">Assigned User</label>
                      <select name="assigned_user" id="assigned_user" class="form-control">
                        <?php if( !empty($company_users->toArray()) ): ?>
                          <?php $__currentLoopData = $company_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company_user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>   

                            <?php 
                              $assigned_user_id = 0;
                              if(!empty($task->assigned_user) || $task->assigned_user != 0) {
                                $assigned_user_id = unserialize($task->assigned_user);
                                $assigned_user = App\User::find($assigned_user_id);
                              }
                            ?>
                            <?php if(isset($company_user->user->firstname) && isset($company_user->user->lastname)): ?>
                              <option <?php echo $assigned_user_id == $company_user->user_id ? 'selected="selected"' : ''; ?> value="<?php echo e($company_user->user_id); ?>"><?php echo e($company_user->user->firstname); ?> <?php echo e($company_user->user->lastname); ?></option>
                            <?php else: ?>

                            <?php endif; ?>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                          <select name="assigned_user" id="assigned_user" class="form-control">
                            <option value="">No company users available</option>
                          </select>
                        <?php endif; ?>
                      </select>                   
                    </div>                
                  </div>
                  <div class="col-xs-4">
                    <div class="form-group">
                      <label for="inputStatusr">Status</label>
                      <select name="status" id="status" class="form-control">
                        <option <?php echo $task->status == 'pending' ? 'selected="selected"' : ''; ?> value="pending">Pending</option>
                        <option <?php echo $task->status == 'in_progress' ? 'selected="selected"' : ''; ?> value="in_progress">In progress</option>
                        <option <?php echo $task->status == 'closed' ? 'selected="selected"' : ''; ?> value="closed">Closed</option>
                        <option <?php echo $task->status == 'completed' ? 'selected="selected"' : ''; ?> value="completed">Completed</option>
                      </select>                   
                    </div>                
                  </div>                  
                </div>

              </div>
              <div class="modal-footer">
                <button type="submit" class="btn btn-default">Update</button>
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
              </div>

            </div>
          </div>
        <?php echo Form::close(); ?>        
    </div>  

    <div id="modalViewTask-<?= $task->id; ?>" class="modal fade bs-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true" style="text-align: left">
          <input type="hidden" name="id" value="<?= Hashids::encode($task->id); ?>">
          <div class="modal-dialog modal-lg">
            <div class="modal-content">

              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span>
                </button>
                <h4 class="modal-title" id="myModalLabel">View Details</h4>
              </div>
              <div class="modal-body">

                <div class="form-group">
                  <label for="inputLocation">Contact: </label>
                  <?php echo e($contact->firstname); ?> <?php echo e($contact->lastname); ?>

                </div>   

                <div class="form-group">
                  <label for="inputTitle">Title</label>
                  <p><?php echo e($task->title); ?></p>
                </div> 

                <div class="form-group">
                  <label for="inputDescription">Notes</label>
                  <?php echo $task->notes; ?>
                </div>    

                <div class="row">
                  <div class="col-xs-4">
                    <div class="form-group">
                      <label for="inputDate">Due Date</label>
                      <p><?php echo date("F j, Y, g:i a", strtotime($task->due_date)); ?></p>
                    </div>                
                  </div>
                  <div class="col-xs-4">
                    <div class="form-group">
                      <label for="inputAssignedUser">Assigned User</label>
                        <?php if( !empty($company_users->toArray()) ): ?>
                          <?php $__currentLoopData = $company_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company_user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>   

                            <?php 
                              $assigned_user_id = 0;
                              if(!empty($task->assigned_user) || $task->assigned_user != 0) {
                                $assigned_user_id = unserialize($task->assigned_user);
                                $assigned_user = App\User::find($assigned_user_id);
                              }
                            ?>
                            <?php if(isset($company_user->user->firstname) && isset($company_user->user->lastname)): ?>
                              <p><?php echo e($company_user->user->firstname); ?> <?php echo e($company_user->user->lastname); ?></p>
                            <?php else: ?>
                              <p>-</p>
                            <?php endif; ?>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                          <p>No company users available</p>
                        <?php endif; ?>                  
                    </div>                
                  </div>
                  <div class="col-xs-4">
                    <div class="form-group">
                      <label for="inputStatusr">Status</label>
                      <p><?php echo e($task->status); ?></p>                
                    </div>                
                  </div>                  
                </div>
              </div>

            </div>
          </div>     
    </div>        

  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</table>

<div style="text-align: center;" class="box-footer clearfix">
    <?php echo e($contact_tasks->links()); ?>

</div>

<div id="modalAddTask" class="modal fade bs-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true" style="text-align: left">
    <?php echo e(Form::open(array('url' => 'contact_task/store', 'class' => '', 'id' => 'add-task-form'))); ?>

      <input type="hidden" name="contact_id" id="contact_id" value="<?php echo e($contact_id); ?>">
      <div class="modal-dialog modal-lg">
        <div class="modal-content">

          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span>
            </button>
            <h4 class="modal-title" id="myModalLabel">Add Task</h4>
          </div>
          <div class="modal-body">

            <div class="form-group">
              <label for="inputLocation">Contact: </label>
              <?php echo e($contact->firstname); ?> <?php echo e($contact->lastname); ?>

            </div>   

            <div class="form-group">
              <label for="inputTitle">Title</label>
              <input type="text" class="form-control" id="title" name="title" value="<?php echo e(old('title')); ?>" placeholder="Enter Title" required="">
            </div>         

            <div class="form-group">
              <label for="inputDescription">Notes</label>
              <textarea rows="4" cols="50" class="form-control" id="task_notes" name="notes" required=""><?php echo e(old('notes')); ?></textarea>
            </div>            

            <div class="row">
              <div class="col-xs-6">
                <div class="form-group">
                  <label for="inputDate">Due Date</label>
                  <input type="text" class="form-control due_date" id="due_date" name="due_date" value="<?php echo e(old('due_date')); ?>" placeholder="" required="">
                </div>                
              </div>
              <div class="col-xs-6">
                <div class="form-group">
                  <label for="inputAssignedUser">Assigned User</label>
                  <select name="assigned_user" id="assigned_user" class="form-control">
                    <?php if( !empty($company_users->toArray()) ): ?>
                      <?php $__currentLoopData = $company_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company_user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>  
                        <?php if(isset($company_user->user->firstname) && isset($company_user->user->lastname)): ?> 
                          <option value="<?php echo e($company_user->user_id); ?>"><?php echo e($company_user->user->firstname); ?> <?php echo e($company_user->user->lastname); ?></option>
                        <?php else: ?>
                          <option value="">-</option>
                        <?php endif; ?>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                      <select name="assigned_user" id="assigned_user" class="form-control">
                        <option value="">No company users available</option>
                      </select>
                    <?php endif; ?>
                  </select>                   
                </div>                
              </div>
            </div>

          </div>
          <div class="modal-footer">
            <button type="submit" class="btn btn-default">Add</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
          </div>

        </div>
      </div>
    <?php echo Form::close(); ?>        
</div>

<?php /**PATH /home/efvyhdmy/public_html/bizboxmca-app/resources/views/contact/dashboard/tab-sections/tab_tasks.blade.php ENDPATH**/ ?>