<div class="row">
  <div class="col-xs-12 calendar-events-header">
    <div class="pull-left calendar-events-title">Notes</div>
    <div class="pull-right">
        <a href="javascript:void(0);" class="btn btn-primary" id="" data-toggle="modal" data-target="#modalAddNote">
            <i class="fa fa-plus"></i> Add Note
        </a>          
        <a href="javascript:location.reload();" class="btn btn-primary">
            <i class="fa fa-refresh"></i>
        </a>
    </div>
  </div>
</div>

<ul class="timeline timeline-inverse">

  <?php if(!$contact_notes->isEmpty()): ?>

    <?php $__currentLoopData = $contact_notes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact_note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <!-- timeline item -->
      <li>
        <i class="fa fa-file-text bg-blue"></i>

        <div class="timeline-item">
          <span class="time"><i class="fa fa-clock-o"></i> <?php echo e(date("F j, Y, g:i a", strtotime($contact_note->created_at))); ?> </span>
          <?php $note_type_name = isset($contact_note->note_type->name) ? $contact_note->note_type->name : 'NA'; ?>
          <h3 class="timeline-header">
            <?php $notify_user = isset($contact_note->notify_user->firstname) ? $contact_note->notify_user->firstname . " " . $contact_note->notify_user->lastname : 'NA'; ?>
            <a href="javascript:void(0);"><?php echo $notify_user; ?></a> | <strong><?php echo e($note_type_name); ?></strong>
            <?php echo " | " . $contact_note->note_title; ?>
          </h3>

          <div class="timeline-body" style="overflow: auto; min-height: 40px; max-height: 120px;">
              <?php echo $contact_note->note_content; ?>
          </div>
          
          <div class="timeline-footer">
            <!-- <a class="btn btn-primary btn-xs">Read more</a> -->
            <a href="javascript:void(0);" class="btn btn-danger btn-xs" data-toggle="modal" data-target="#modalDeleteNote-<?= $contact_note->id; ?>">
                Delete
            </a>            
          </div>
        </div>
      </li>
      <!-- END timeline item -->

      <div id="modalDeleteNote-<?= $contact_note->id; ?>" class="modal fade bs-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true" style="text-align: left">
          <div class="modal-dialog modal-md">
            <div class="modal-content">

              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span>
                </button>
                <h4 class="modal-title" id="myModalLabel">Delete</h4>
              </div>
              <div class="modal-body">
                Are you sure you want to delete selected note?
              </div>
              <div class="modal-footer">
                <?php echo e(Form::open(array('url' => 'contact_note/destroy'))); ?>

                  <?php echo Form::hidden('id', Hashids::encode($contact_note->id) ,[]); ?>
                  <button type="button" class="btn btn-default" data-dismiss="modal">No</button>
                  <button type="submit" class="btn btn-danger">Yes</button>
                <?php echo Form::close(); ?>

              </div>

            </div>
          </div>
      </div>  

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <li>
      <i class="fa fa-clock-o bg-gray"></i>
    </li>

  <?php else: ?>
    <li>
      <i class="fa fa-file-text bg-blue"></i>
      <div class="timeline-item"><h3 class="timeline-header"><strong>Note is empty</strong></h3></div>  
    </li>
  <?php endif; ?>

</ul>

<div style="text-align: center;" class="box-footer clearfix">
    <?php echo e($contact_notes->links()); ?>

</div>

<div id="modalAddNote" class="modal fade bs-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true" style="text-align: left">
    <?php echo e(Form::open(array('url' => 'contact_note/store', 'class' => '', 'id' => 'add-note-form'))); ?>

      <input type="hidden" name="contact_id" id="contact_id" value="<?php echo e($contact_id); ?>">
      <div class="modal-dialog modal-lg">
        <div class="modal-content">

          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span>
            </button>
            <h4 class="modal-title" id="myModalLabel">Add Note</h4>
          </div>
          <div class="modal-body">
            <div class="row">
              <div class="col-xs-6">
                <div class="form-group">
                  <label for="inputNoteType">Note Type</label>
                  <select name="note_type_id" id="note_type_id" class="form-control">
                    <?php if( !empty($note_types->toArray()) ): ?>
                      <?php $__currentLoopData = $note_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>   
                        <option value="<?php echo e($nt->id); ?>"><?php echo e($nt->name); ?></option>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                      <select name="note_type_id" id="note_type_id" class="form-control">
                        <option value="">No event type available</option>
                      </select>
                    <?php endif; ?>
                  </select>  
                </div>                
              </div>
              <div class="col-xs-6">
                <div class="form-group">
                  <label for="inputNotifyUser">Notify User</label>
                  <select name="notify_user_id" id="notify_user_id" class="form-control">
                    <?php if( !empty($company_users->toArray()) ): ?>
                      <?php $__currentLoopData = $company_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company_user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>   
                        <?php if(isset($company_user->user->firstname) && isset($company_user->user->lastname)): ?>
                          <option value="<?php echo e($company_user->user_id); ?>"><?php echo e($company_user->user->firstname); ?> <?php echo e($company_user->user->lastname); ?></option>
                        <?php else: ?>
                          <option value="">-</option>
                        <?php endif; ?>
                        
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                      <select name="notify_user_id" id="notify_user_id" class="form-control">
                        <option value="">No company users available</option>
                      </select>
                    <?php endif; ?>
                  </select>                   
                </div>                
              </div>
            </div>

            <div class="row">
              <div class="col-xs-6">
                <div class="form-group">
                  <label for="inputNoteTemplate">Note Template</label>
                  <select name="note_template" id="note_template" class="form-control"> 
                    <option value="">Blank</option>
                  </select>  
                </div>                
              </div>
              <div class="col-xs-6">
                <div class="form-group">
                  <label for="inputccEmail">CC Email</label>
                  <input type="text" class="form-control cc_emails" id="cc_emails" name="cc_emails" placeholder="" value="<?php echo e(old('cc_emails')); ?>">
                </div>                
              </div>
            </div>            

            <div class="form-group">
              <label for="inputTitle">Title</label>
              <input type="text" class="form-control" id="note_title" name="note_title" placeholder="Enter Title" value="<?php echo e(old('note_title')); ?>" required="">
            </div>            

            <div class="form-group">
              <textarea rows="4" cols="50" class="form-control" id="note_content" name="note_content" required=""><?php echo e(old('note_content')); ?></textarea>
            </div>
          </div>
          <div class="modal-footer">
            <button type="submit" class="btn btn-default">Add</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
          </div>

        </div>
      </div>
    <?php echo Form::close(); ?>        
</div>

<?php /**PATH C:\laragon\www\juke\itcss4b\resources\views/contact/dashboard/tab-sections/tab_notes.blade.php ENDPATH**/ ?>