<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Illuminate\Support\Facades\Auth;
use App\EventType;
use App\ContactTask;
use App\ContactHistory;
use App\Contact;
use UserHelper;

use View;
use Hash;
use Hashids;

use Session;

class NotificationController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');       
        $this->middleware(function ($request, $next) {

            $user_id  = Auth::user()->id;
            $group_id = Auth::user()->group_id;
            $module   = 'settings';
            $with_permission = UserHelper::checkUserRole($group_id, $module); 
            if(!$with_permission) {
                Session::flash('message', 'You have no permission to access the '. $module . ' page.');
                Session::flash('alert_class', 'alert-danger');                
                return redirect('dashboard');
            }    

            $pending_task_count = ContactTask::where('assigned_user_id','=', $user_id)->where('status','=', 'pending')->count();
            $pending_task       = ContactTask::where('assigned_user_id','=', $user_id)->where('status','=', 'pending')->get();

            $bankruptcy         = UserHelper::getCompaniesBankrupt();

            $idl_contacts = UserHelper::getIdleContacts();
            $idle_contacts_count = 0;
            $idle_contacts       = array();
            if(!empty($idl_contacts)) {
                $idle_contacts_count = $idl_contacts['total_idle'];
                $idle_contacts       = $idl_contacts['idle_data'];
            }
            $settled            = UserHelper::getContactsSettled();
            View::share ( 'settled', $settled );
            View::share ( 'idle_contacts_count', $idle_contacts_count );   
            View::share ( 'idle_contacts', $idle_contacts);             

            View::share ( 'pending_task_count', $pending_task_count );   
            View::share ( 'pending_task', $pending_task);               
            
            View::share ( 'bankruptcy', $bankruptcy);               

            return $next($request);     
        });           
    }

    public function bankruptcy(Request $request)
    {
    	$search_by    = $request->input('search_by');
        $search_field = $request->input('search_field');  

        if($search_by != '' && $search_field != '') {
            $event_type_query = EventType::query();

            if($search_by != '' && $search_field != '') {
            	$bankruptcy = UserHelper::getCompaniesBankrupt($search_field);
            }            
        } else {
            $bankruptcy = UserHelper::getCompaniesBankrupt();
        }        

        return view('notification.bankruptcy',[
        	'bankruptcy' => $bankruptcy,
        	'search_field' => $search_field
        ]); 
    }

    public function settled(Request $request)
    {
    	$search_by    = $request->input('search_by');
        $search_field = $request->input('search_field');  

        if($search_by != '' && $search_field != '') {
            $event_type_query = EventType::query();

            if($search_by != '' && $search_field != '') {
            	$settled = UserHelper::getContactsSettled($search_field);
            }            
        } else {
            $settled = UserHelper::getContactsSettled();
        }        

        return view('notification.settled',[
        	'settled' => $settled,
        	'search_field' => $search_field
        ]); 
    }

    public function idle_contacts(Request $request)
    {
        $idl_contacts = UserHelper::getIdleContacts();
        return view('notification.idle_contacts',[
            'idle_contacts' => $idl_contacts['contacts_data']
        ]); 
    }
}
