<?php
namespace App\Helpers;

use App\SmsAutomation;
use App\SmsAutomationNumber;

use Session;

use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class SmsAutomationHelper
{
      const ADMIN_USER     = 1;
      const COMPANY_USER   = 2;
      const CUSTOMER_USER  = 3;
      const RTR_USER       = 4;

      const USER_ACTIVE    = 0;
      const USER_SUSPENDED = 1;

      const ACCESS_TYPE_VIEW_ONLY = 1; //View Only
      CONST ACCESS_TYPE_ALL       = 2; //ACCESS ALL (View, Edit & Delete)

      public static function getAutomationSentDetails($sms_automation_id) 
      {
            $summary = [];
            $total_sent    = 0;
            $total_errors  = 0;
            $total_numbers = 0;

             $smsAutomationNumber = SmsAutomationNumber::where('sms_automation_id', $sms_automation_id)->get();
             foreach($smsAutomationNumber as $smsNumber){                         
                  if( $smsNumber->is_sent == 1 && $smsNumber->is_error == 0 ){
                        $total_sent++;
                  }

                  if( $smsNumber->is_error == 1 ){
                        $total_errors++;
                  }

                  $total_numbers++;
             }             
            
             $summary = [
                  'total_numbers' => $total_numbers,
                  'total_sent' => $total_sent,
                  'total_errors' => $total_errors
             ];
            return $summary; 
      }

      public static function ruleNotifyReadableText( $rule_notify ) {
            $day_week = 'Day';
            if (strpos($rule_notify, 'W') !== false) {
                  $day_week = 'Week';
            }

            $num = (int)$rule_notify;            
            if( $num > 1 ){
                  $day_week = $day_week.'s';
            }

            $rule_notify_text = $num.' '.$day_week;

            return $rule_notify_text;
      }
}
?>